---@meta

---@class AColorCorrectRegion : AActor
---@field MeshComponents TArray<UStaticMeshComponent>
---@field Type EColorCorrectRegionsType
---@field Priority int32
---@field Intensity float
---@field Inner float
---@field Outer float
---@field Falloff float
---@field Invert boolean
---@field TemperatureType EColorCorrectRegionTemperatureType
---@field Temperature float
---@field Tint float
---@field ColorGradingSettings FColorGradingSettings
---@field Enabled boolean
---@field bEnablePerActorCC boolean
---@field PerActorColorCorrection EColorCorrectRegionStencilType
---@field AffectedActors TSet<TSoftObjectPtr<AActor>>
---@field IdentityComponent UColorCorrectionInvisibleComponent
---@field PositionalParams FDisplayClusterPositionalParams
---@field Origin FTransform
local AColorCorrectRegion = {}

---@param InValue double
function AColorCorrectRegion:SetYaw(InValue) end
---@param InValue double
function AColorCorrectRegion:SetSpin(InValue) end
---@param InScale FVector2D
function AColorCorrectRegion:SetScale(InScale) end
---@param InValue double
function AColorCorrectRegion:SetRadialOffset(InValue) end
---@param InParams FDisplayClusterPositionalParams
function AColorCorrectRegion:SetPositionalParams(InParams) end
---@param InValue double
function AColorCorrectRegion:SetPitch(InValue) end
---@param InOrigin FTransform
function AColorCorrectRegion:SetOrigin(InOrigin) end
---@param InValue double
function AColorCorrectRegion:SetLongitude(InValue) end
---@param InValue double
function AColorCorrectRegion:SetLatitude(InValue) end
---@param InValue double
function AColorCorrectRegion:SetDistanceFromCenter(InValue) end
---@return double
function AColorCorrectRegion:GetYaw() end
---@return double
function AColorCorrectRegion:GetSpin() end
---@return FVector2D
function AColorCorrectRegion:GetScale() end
---@return double
function AColorCorrectRegion:GetRadialOffset() end
---@return FDisplayClusterPositionalParams
function AColorCorrectRegion:GetPositionalParams() end
---@return double
function AColorCorrectRegion:GetPitch() end
---@return FTransform
function AColorCorrectRegion:GetOrigin() end
---@return double
function AColorCorrectRegion:GetLongitude() end
---@return double
function AColorCorrectRegion:GetLatitude() end
---@return double
function AColorCorrectRegion:GetDistanceFromCenter() end


---@class AColorCorrectionRegion : AColorCorrectRegion
local AColorCorrectionRegion = {}


---@class AColorCorrectionWindow : AColorCorrectRegion
---@field WindowType EColorCorrectWindowType
local AColorCorrectionWindow = {}



---@class ADEPRECATED_ColorCorrectWindow : AColorCorrectionWindow
local ADEPRECATED_ColorCorrectWindow = {}


---@class UColorCorrectRegionsSubsystem : UWorldSubsystem
local UColorCorrectRegionsSubsystem = {}

function UColorCorrectRegionsSubsystem:RefreshStenciIdAssignmentForAllCCR() end


---@class UColorCorrectionInvisibleComponent : UPrimitiveComponent
local UColorCorrectionInvisibleComponent = {}


